unit uhrunit;

interface

const year=9;
      century=50;
      month=8;
      day=7;
      second=0;
      minute=2;
      hour=4;

procedure settime2bios;
function getzeit(r: Word): Word;
function getyear:word;
function dow: string;
function DW(D,M,Y:word):word;
function datum : string;
function uhrzeit: string;
function smallzeit: string;
function zeiteingeben(var w:string;var s:boolean):boolean;
function dateeingeben(var w:string;var s:boolean;alles:boolean):boolean;
procedure beep;
function schaltjahr(y:word):boolean;
function MonatsTage(m,y:word):word;
function LeadingZero(w : Word) : String;
function tage(jahr1,jahr2,monat1,monat2,tag1,tag2:longint):longint;

implementation

uses dos,crt,graph;

procedure beep;
begin
 sound(900);
 delay(50);
 nosound
end;

function LeadingZero(w : Word) : String;
 var s : String;
 begin
   Str(w:0,s);
   if Length(s) = 1 then
     s := '0' + s;
   LeadingZero := s;
 end;

function getzeit(r: Word): Word;
var w:word;
begin
 Port[$70]:=r;
 w:=Port[$71];
 getzeit:=w SHR 4*10+w AND 15
end;

function getyear:word;
var I,i1:integer;
begin
 val(leadingzero(getzeit(century))+leadingzero(getzeit(year)),i,i1);
 getyear:=i;
end;

procedure settime2bios;
begin
 settime(getzeit(hour),getzeit(minute),getzeit(second),0);
 setdate(getzeit(day),getzeit(month),getyear);
end;

function schaltjahr(y:word):boolean;
BEGIN
 schaltjahr:=false;
 IF(y>=1582) THEN
  BEGIN
   IF (y MOD 4=0) AND ((y MOD 100>0) OR (y MOD 400=0)) THEN schaltjahr:=true;
  END
  ELSE IF (y MOD 4=0) THEN schaltjahr:=true;
END;

function MonatsTage(m,y:word):word;
BEGIN
  CASE m OF
  1,3,5,7,8,10,12:MonatsTage:=31;
  4,6,9,11:       MonatsTage:=30;
  2:              IF schaltjahr(y) THEN MonatsTage:=29 ELSE MonatsTage:=28;
 END;
END;

function tage(jahr1,jahr2,monat1,monat2,tag1,tag2:longint):longint;
var i,i2:integer;
    e1:longint;
    s:string;
begin
 e1:=0;
 if jahr2-jahr1>1 then
  begin
   for i:=jahr1+1 to jahr2-1 do
   if schaltjahr(i) then e1:=e1+366 else e1:=e1+365;
  end;
 if jahr2-jahr1>0 then
  begin
   for i:=monat1+1 to 12 do e1:=e1+monatstage(i,jahr1);
   for i:=1 to monat2-1 do e1:=e1+monatstage(i,jahr2);
  end;
 if (jahr2-jahr1=0) and (monat2-monat1>1) then
  begin
   for i:=monat1+1 to monat2-1 do e1:=e1+monatstage(i,jahr1);
  end;
 if monat1<>monat2 then e1:=e1+tag2+(monatstage(monat1,jahr1)-tag1)
  else e1:=e1+tag2-tag1;
 tage:=e1;
end;

function DW(D,M,Y:word):word;
VAR c:LongInt;
    cM,cY:word;
BEGIN
 cM:=1;
 cY:=0;
 c:=4;
 WHILE cY<Y DO
  BEGIN
   IF schaltjahr(cY) THEN INC(c,366)ELSE INC(c,365);
   INC(cY);
  END;
 WHILE cM<M DO
  BEGIN
   INC(c,MonatsTage(cM,Y));
   INC(cM);
  END;
 INC(c,D);
 IF Y>=1582 THEN DEC(c,3);
 WHILE c>7 DO DEC(c,7);
 DEC(c);
 IF c<1 THEN c:=7;
 DW:=c;
END;

function dow: string;
var t,i:integer;
begin
 case dw(getzeit(day),getzeit(month),getyear) of
  2:dow:='Dienstag';
  3:dow:='Mittwoch';
  4:dow:='Donnerstag';
  5:dow:='Freitag';
  6:dow:='Samstag';
  7:dow:='Sonntag';
  1:dow:='Montag';
 end; {case}
end;

function dateeingeben(var w:string;var s:boolean;alles:boolean):boolean;
var i,x,y,i2,k:integer;
    eing:char;
    falsch:boolean;
    t:array [1..8] of char;
    st:string;
const notbest:boolean=true;
      selbe:boolean=false;
procedure pruefen(pr:integer);
begin
 falsch:=true;
 case pr of
 1:begin
   t[1]:=eing;
   if t[1] in ['0'..'3'] then falsch:=false;
  end;
 2:begin
   t[2]:=eing;
   if t[2] in ['0'..'1'] then falsch:=false;
   if t[1] in ['0'..'2'] then if t[2] in ['2'..'9'] then falsch:=false;
   if (t[1]='0') and (t[2]='0') then falsch:=true;
  end;
 3:begin
   t[3]:=eing;
   if t[3] in ['0','1'] then falsch:=false;
  end;
 4:begin
   t[4]:=eing;
   if t[3]='0' then if t[4] in ['0'..'9'] then falsch:=false else
    else if t[4] in ['0'..'2'] then falsch:=false;
   if (t[3]='0') and (t[4]='0') then falsch:=true;
  end;
 5:begin
   t[5]:=eing;
   if alles then if t[5] in ['0'..'9'] then falsch:=false else else
     if t[5] in ['1','2'] then falsch:=false;
  end;
 6:begin
   t[6]:=eing;
   if alles then if t[6] in ['0'..'9'] then falsch:=false else else
    begin
     if t[5]='1' then if t[6]='9' then falsch:=false;
     if t[5]='2' then if t[6]='0' then falsch:=false;
    end;
  end;
7,8:begin
    t[pr]:=eing;
    if alles then if t[pr] in ['0'..'9'] then falsch:=false else else
      if eing in ['0'..'9'] then falsch:=false;
    end;
   end;{case}
 if falsch then beep;
end;
begin
 x:=getx;
 y:=gety;
 i:=0;
 dateeingeben:=true;
 st:='';
 selbe:=false;
 while (i<>9) or notbest do
  begin
   inc(i);
   if ((i=3) or (i=5)) and not selbe then outtext('.');
   falsch:=true;
   while falsch and not selbe do
    begin
     k:=0;
     while not (keypressed or (i=9)) do
      begin
       inc(k);
       if k in [0..40] then
        begin
         setcolor(15);
         line(x+textwidth(st)-2,y+textheight(st)+2,x+textwidth(st)+textwidth('0')-4,y+textheight(st)+2);
         delay(10);
        end
       else if k in [40..80] then
        begin
         setcolor(0);
         line(x+textwidth(st)-2,y+textheight(st)+2,x+textwidth(st)+textwidth('0')-4,y+textheight(st)+2);
         delay(10);
        end else k:=0;
      end;
     setcolor(0);
     line(x+textwidth(st)-2,y+textheight(st)+2,x+textwidth(st)+textwidth('0')-4,y+textheight(st)+2);
     setcolor(15);
     eing:=readkey;
     if (eing=#27) then
      begin
       falsch:=false;
       notbest:=false;
       dateeingeben:=false;
       i:=9;
      end
     else
      begin
       if s and (i=1) and (eing=#13) then
        begin
         w:=datum;
         selbe:=true;
         i:=9;
         notbest:=false;
        end
       else
        if (i=9) and (eing=#13) then
         begin
          falsch:=false;
          notbest:=false;
         end
       else
        begin
         falsch:=true;
         if eing=#8 then
          begin
          falsch:=false;
          if i=1 then
           begin
            beep;
            dec(i)
           end
          else
           begin
            dec(i);
            delete(st,length(st),1);
            if i in [2,4] then delete(st,length(st),1);
            dec(i);
            setcolor(0);
            moveto(x,y);
            for i2:=1 to 8 do
             begin
              if i2 in [3,5] then outtext('.');
              outtext(t[i2]);
             end;
            setcolor(15);
            moveto(x,y);
            t[i+1]:=#0;
            for i2:=1 to i do
             begin
              if i2 in [3,5] then outtext('.');
              outtext(t[i2]);
            end;
           end
           end
          else
           begin
            pruefen(i);
            if not falsch and not selbe then
             begin
              st:=st+eing;
              if i in [2,4] then st:=st+'.';
              outtext(eing);
             end
           end
        end
      end
    end
  end;
 if selbe then
  begin
   outtext(w);
   s:=true;
  end
  else
  begin
   s:=false;
   for i:=1 to 8 do
    begin
     if i in [3,5] then w:=w+'.';
     w:=w+t[i];
    end;
   end;
end;

function zeiteingeben(var w:string;var s:boolean):boolean;
var k,i,x,y,i2:integer;
    eing:char;
    falsch:boolean;
    t:array [1..6] of char;
    st:string;
const notbest:boolean=true;
      selbe:boolean=false;
procedure pruefen(pr:integer);
begin
 falsch:=true;
 if pr=1 then
  begin
   t[1]:=eing;
   if t[1] in ['0'..'2'] then falsch:=false;
  end;
 if pr=2 then
  begin
   t[2]:=eing;
   if t[2] in ['0'..'3'] then falsch:=false;
   if t[1]<>'2' then if t[2] in ['4'..'9'] then falsch:=false;
  end;
 if pr=3 then
  begin
   t[3]:=eing;
    if t[3] in ['0'..'5'] then falsch:=false;
  end;
 if (pr=4) or (pr=6) then
  begin
   if pr=4 then t[4]:=eing else t[6]:=eing;
   if eing in ['0'..'9'] then falsch:=false;
  end;
 if pr=5 then
  begin
   t[5]:=eing;
    if t[5] in ['0'..'5'] then falsch:=false;
  end;
 if falsch then beep;
end;
begin
 x:=getx;
 y:=gety;
 i:=0;
 zeiteingeben:=true;
 st:='';
 selbe:=false;
 while (i<>7) or notbest do
  begin
   inc(i);
   if ((i=3) or (i=5)) and not selbe then outtext(':');
   falsch:=true;
   while falsch and not selbe do
    begin
     k:=0;
     while not (keypressed or (i=7)) do
      begin
       inc(k);
       if k in [0..40] then
        begin
         setcolor(15);
         line(x+textwidth(st)-2,y+textheight(st)+2,x+textwidth(st)+textwidth('O')-4,y+textheight(st)+2);
         delay(10);
        end
       else if k in [40..80] then
        begin
         setcolor(0);
         line(x+textwidth(st)-2,y+textheight(st)+2,x+textwidth(st)+textwidth('O')-4,y+textheight(st)+2);
         delay(10);
        end else k:=0;
      end;
     setcolor(0);
     line(x+textwidth(st)-2,y+textheight(st)+2,x+textwidth(st)+textwidth('O')-4,y+textheight(st)+2);
     setcolor(15);
     eing:=readkey;
     if (eing=#27) then
      begin
       falsch:=false;
       notbest:=false;
       zeiteingeben:=false;
       i:=7;
      end
     else
      begin
       if s and (i=1) and (eing=#13) then
        begin
         w:=smallzeit;
         selbe:=true;
         i:=7;
         notbest:=false;
        end
       else
        if (i=7) and (eing=#13) then
         begin
          falsch:=false;
          notbest:=false;
         end
       else
        begin
         falsch:=true;
         if eing=#8 then
          begin
          falsch:=false;
          if i=1 then
           begin
            beep;
            dec(i)
           end
          else
           begin
            delete(st,length(st),1);
            dec(i);
            if i in [2,4] then delete(st,length(st),1);
            dec(i);
            setcolor(0);
            moveto(x,y);
            for i2:=1 to 6 do
            begin
             if i2 in [3,5] then outtext(':');
             outtext(t[i2]);
            end;
            setcolor(15);
            moveto(x,y);
            t[i+1]:=#0;
            for i2:=1 to i do
             begin
              if i2 in [3,5] then outtext(':');
              outtext(t[i2]);
            end;
           end
           end
          else
           begin
            pruefen(i);
            if not falsch and not selbe then
             begin
              st:=st+eing;
              if i in [2,4] then st:=st+':';
              outtext(eing);
             end
           end
        end
      end
    end
  end;
 if selbe then
  begin
   outtext(w);
   s:=true;
  end else
  begin
  for i:=1 to 6 do
   begin
    if i in [3,5] then w:=w+':';
    w:=w+t[i];
   end;
  s:=false;
  end;
end;

function datum : string;
begin
 Datum:=LeadingZero(getzeit(day))+'.'+LeadingZero(getzeit(month))+'.'+leadingzero(getyear);
end;

function uhrzeit:string;
var h, m, s,hund:word;
begin
 gettime(h,m,s,hund);
 uhrzeit:=LeadingZero(getzeit(hour))+':'+LeadingZero(getzeit(minute))+':'+LeadingZero(getzeit(second))+'.'+LeadingZero(hund);
end;

function smallzeit:string;
begin
 smallzeit:=LeadingZero(getzeit(hour))+':'+LeadingZero(getzeit(minute))+':'+LeadingZero(getzeit(second))
end;

end.