unit myunit;

interface

const allezeichen=[#32..#126,#132,#142,#129,#154,#148,#153,#225,#253,#252,#230];
type chr = set of char;
type char79=array [0..79] of char;

procedure writexy(x,y:integer;s:string);
function eingabe(bereich:chr;laenge:integer;vorgabe:string):string;
procedure setfarbe(i,r,g,b:integer);
procedure kasten(hoehe,breite,anf,vfarb,hfarb,hhf:word);
function GetCursor : Integer;
procedure lcdzahl(wert:longint;xkor,ykor,gross:integer;vfarb,hfarb,stell:byte);
procedure SetCursor(NewCursor : Integer);
procedure Showcursor(tempcursor:integer);
procedure Hidecursor(var oldcursor:integer);
procedure normcursor;
procedure fullcursor;
function  greingabe(ch:chr;laenge:integer;var ein:boolean):string;
function other(b:boolean):boolean;
function upstr(s:string):string;
function downstr(s:string):string;
function printer_ready(var meldung:string): boolean;

implementation

uses dos,crt,graph,uhrunit,strings;

function other(b:boolean):boolean;
begin
 if b then other:=false else other:=true;
end;

procedure writexy(x,y:integer;s:string);
begin
  gotoxy(x,y);
  write(s);
end;

function printer_ready(var meldung:string): boolean;
var regs : registers;
    code: byte;
    status: boolean;
begin
 regs.ah:=$02;
 regs.dx:=$00;
 intr($17,regs);
 code:=regs.ah;
 status:=true;
 if (code and 16)=16 then
  begin                                  {Bit4=1->Druck Ein}
   if (code and 128)<>128 then          {Bit7<>1->Druck nicht Bereit}
    if (code and 32)=32 then          {Drucker bereit}
     begin                                {Bit5=1->Druck Kein Papier}
      status:=false;
      meldung:='Druckerfehler! Kein Papier!';
     end
    else
     begin
      status:=false;
      meldung:='Druckerfehler! OFFLINE!';{Offline oder Fehler(Bit 3=0)}
     end;
  end
 else
  begin    {Drucker ausgeschaltet}
   status:=false;
   meldung:='Druckerfehler! OFFLINE oder Ausgeschaltet!';
  end;
 printer_ready:=status
end;

function eingabe(bereich:chr;laenge:integer;vorgabe:string):string;
var s:string;
    n,x,y,i:integer;
    c,c2:char;
    einfg:boolean;
begin
 textcolor(15);
 einfg:=true;
 setcursor(3342);
 x :=   wherex;
 y :=   wherey;
 if not (vorgabe[1] in bereich) then
  begin
   c:=vorgabe[1];
   vorgabe:='';
  end;
 s :=   vorgabe;
 i :=   length(vorgabe);
 c :=   #0;
 writexy(x,y,vorgabe);
 for n:=1 to laenge-1 do writexy(x+n,y,'.');
 while not (c=#13) do
  begin
   if length(s)<laenge then writexy   (x+length(s),y,'.');
   writexy              (x,y,s);
   gotoxy               (x+i,y);
   c := readkey;
   if (c in bereich) or (c in [#8,#0,#224]) then
     if c in bereich then
      begin
       if (length(s)<laenge) then
        begin
         if i=length(s) then    s :=           s+c
          else  if einfg then   insert         (c,s,i+1)
                 else
                  begin
                   delete       (s,i+1,1);
                   insert       (c,s,i+1);
                  end;
         inc            (i);
        end;
      end;{if}
     case c of
               #8 : if i>=1 then
                      begin
                        delete      (s,i,1);
                        dec         (i);
                       end;
          #224,#0 : begin
		       c2:=readkey;
		       case c2 of
		        #75 : if i>=1 then dec(i) ;
 		        #77 : if i<length(s) then inc(i);
                        #82 : if einfg then
                               begin
                                einfg     :=false;
                                setcursor (8);
                               end
                              else
                               begin
                                einfg     :=true;
                                setcursor (3342);
                               end; {if}
                        #83 : delete    (s,i+1,1);
                        #71 : i:=0;
                        #79 : i:=length(s);
                       end; {case}
		     end;
     end;{case}
  end;{while}
 eingabe := s;
end;

procedure lcdzahl(wert:longint;xkor,ykor,gross:integer;vfarb,hfarb,stell:byte);
VAR z		  : ARRAY[0..9,1..7] OF byte;
    t		  : STRING;
    j,w,m,i : integer;
PROCEDURE Digit(x,y,s,n:integer);
var k,l:integer;
PROCEDURE V(a,b,c,d,f,r:integer);
var I:integer;
BEGIN setcolor(z[n,f]);
 setlinestyle(0,1,1);
 for i:=0 to s div 8 do BEGIN
  line(a+i,b+r*i,c+r*i,d-i);
  line(a-r*i,b+i,c-i,d-r*i)
 END
END;
BEGIN if n<0 then n:=0;m:=s+2;
 for k:=0 to 1 do
 for l:=0 to 1 do
 BEGIN V(x+l*m,y+k*m,x+l*m,
  y+s+k*m,1+k+2*l,1);
  v(x+1,y-1+(k+l)*m,x+s+1,
  y-1+(k+l)*m,5+k+l,-1)
 END
END;
PROCEDURE Zahl(x,y,s,a,i:longint);
var p:integer;
BEGIN str(i:a,t);
 FOR p:=1 TO a DO
  Digit(x-(a-p)*s*11 div 5,y,s,
  ord(t[p])-48)
END;
BEGIN
 for i:=0 to 9 do for
 j:=1 to 7 do z[i,j]:=vfarb;
 z[0,6]:=hfarb;
 for i:=1 to 2 do BEGIN
  z[1,i]:=hfarb;z[1,7-i]:=hfarb;
  z[7,i]:=hfarb;z[7,8-i]:=hfarb;
  z[5,1+i]:=hfarb;z[1+i,1]:=hfarb;
  z[2+i,2]:=hfarb;z[3*i-2,7]:=hfarb;
  z[2*i,3+i]:=hfarb;z[3+3*i,4-i]:=hfarb
 end;
 zahl(xkor,ykor,gross,stell,wert);
end;

procedure setfarbe(i,r,g,b:integer);
var n:integer;
begin
 case i of
  6:N:=20;
  8:N:=56;
  9:N:=57;
  10:N:=58;
  11:N:=59;
  12:N:=60;
  13:N:=61;
  14:N:=62;
  15:N:=63;
  else n:=i;
 end;{case}
 setrgbpalette(n,r,g,b);
end;

procedure kasten(hoehe,breite,anf,vfarb,hfarb,hhf:word);
var i,a,i2:integer;
begin
 textcolor(vfarb);
 textbackground(hfarb);
 a:=(82-(breite+2)) div 2;
 gotoxy(a,anf);
 write(#201);
 for i:=1 to breite do write(#205);
 write(#187);
 for i:=1 to hoehe do
 begin
  textcolor(vfarb);
  textbackground(hfarb);
  gotoxy(a,anf+i);
  write(#186);
  textcolor(hfarb);
  for i2:=1 to breite do write(#219);
  gotoxy(a+breite+1,anf+i);
  textcolor(vfarb);
  write(#186);
  textbackground(hhf);
  textcolor(0);
  write(#177);
 end;
 textcolor(vfarb);
 textbackground(hfarb);
 gotoxy(a,anf+hoehe+1);
 write(#200);
 for i:=1 to breite do write(#205);
 write(#188);
 textbackground(hhf);
 textcolor(0);
 write(#177);
 gotoxy(a+1,anf+hoehe+2);
 for i:=1 to breite+2 do write(#177);
 textcolor(vfarb);
 textbackground(hfarb);
end;

function upstr(s:string):string;
var pc:char79;
begin
 strpcopy(pc,s);
 upstr:=strpas(strupper(pc));
end;

function downstr(s:string):string;
var pc:char79;
begin
 strpcopy(pc,s);
 downstr:=strpas(strlower(pc));
end;

function  greingabe(ch:chr;laenge:integer;var ein:boolean):string;
var einga:string;
    c:char;
    cr:chr;
    i,x,y,k:integer;
    eingbest:boolean;
begin
 cr:=[#8,#13,#27];
 i:=0;
 x:=getx;
 y:=gety;
 einga:='';
 eingbest:=false;
 while not eingbest do
  begin
   if i<=laenge then inc(i);
   k:=0;
   while not (keypressed or (i=laenge+1)) do
    begin
     inc(k);
     if k in [0..40] then
      begin
       setcolor(15);
       line(x+textwidth(einga)-2,y+textheight(einga)+2,x+textwidth(einga)+textwidth('O')-4,y+textheight(einga)+2);
       delay(10);
      end
     else if k in [40..80] then
      begin
       setcolor(0);
       line(x+textwidth(einga)-2,y+textheight(einga)+2,x+textwidth(einga)+textwidth('O')-4,y+textheight(einga)+2);
       delay(10);
      end else k:=0;
    end;
   setcolor(0);
   line(x+textwidth(einga)-2,y+textheight(einga)+2,x+textwidth(einga)+textwidth('O')-4,y+textheight(einga)+2);
   setcolor(15);
   c:=readkey;
   if  (c in cr) or (c in ch) then
    begin
     if (i=laenge+1) and not (c in cr) then beep;
     if c=#8 then
     if i=1 then
      begin
       beep;
       dec(i);
      end
     else
      begin
       setcolor(0);
       outtextxy(x,y,einga);
       setcolor(15);
       delete(einga,length(einga),1);
       outtextxy(x,y,einga);
       dec(i,2);
      end
     else
       if (c=#27) or (c=#13) then
        begin
         if (i=1) or (c=#27) then einga:='';
         eingbest:=true;
         ein:=true;
        end
       else
       begin
       if i<=laenge then
        begin
         einga:=einga+c;
         outtextxy(x,y,einga);
        end;
     end;
    end
   else
    begin
     dec(i);
     beep;
     if c=#0 then readkey;
    end;
  end;
 if c=#27 then ein:=false;
 greingabe:=einga;
end;

function GetCursor : Integer;
var
  Reg : Registers;
begin
  with Reg do
  begin
    AH := 3;
    BH := 0;
    Intr($10, Reg);
    GetCursor := CX;
  end;
end;

procedure SetCursor(NewCursor : Integer);
var
  Reg : Registers;
begin
  with Reg do
  begin
    AH := 1;
    BH := 0;
    CX := NewCursor;
    Intr($10, Reg);
  end;
end;

procedure Showcursor(tempcursor:integer);
begin
  SetCursor(TempCursor);
end;

procedure Hidecursor(var oldcursor:integer);
begin
  oldCursor := GetCursor;
  SetCursor($2000);
end;

procedure normcursor;
begin
 setcursor(3342);
end;

procedure fullcursor;
begin
 setcursor(8);
end;

end.