unit bgiunit;
interface

var vesa16:integer;

function att:string;
function cg:string;
function ibm:string;
function egavga:string;
function her:string;
function pc:string;
function vesa:string;
function goth:string;
function sans:string;
function small:string;
function trip:string;
function bold:string;
function euro:string;
function lcom:string;
function scri:string;
function simp:string;
function tscr:string;

implementation

uses graph,bgidr1,bgidr2,bgifo1,bgifo2,bgifo3;

function att:string;
begin
 registerbgidriver(@attdriverProc);
 att:=grapherrormsg(graphresult);
end;
function cg:string;
begin
 registerbgidriver(@cgadriverProc);
 cg:=grapherrormsg(graphresult);
end;
function egavga:string;
begin
 registerbgidriver(@egavgadriverProc);
 egavga:=grapherrormsg(graphresult);
end;
function her:string;
begin
 registerbgidriver(@hercdriverProc);
 her:=grapherrormsg(graphresult);
end;
function pc:string;
begin
 registerbgidriver(@pc3270driverProc);
 pc:=grapherrormsg(graphresult);
end;
function vesa:string;
function GetHighestCap(Table: Pointer; Modes: Word; Size: Integer): Integer;
  near; assembler;
asm
        XOR     AX,AX
        LES     DI, Table
@@1:
        MOV     SI, Modes
        ADD     SI, Size
        ADD     SI, Size
        MOV     BX, ES:[DI]
        CMP     BX, 0FFFFH
        JE      @@4
        INC     DI
        INC     DI
        MOV     CX,Size
@@2:
        CMP     BX,[SI]
        JZ      @@3
        DEC     SI
        DEC     SI
        LOOP    @@2
@@3:
        CMP     AX,CX
        JA      @@1
        MOV     AX,CX
        JMP     @@1
@@4:
end;
function DetectVesa16: Integer; far; assembler;
type
  VgaInfoBlock = record
    VESASignature: array[0..3] of Byte;
    VESAVersion: Word;
    OEMStringPtr: Pointer;
    Capabilities: array[0..3] of Byte;
    VideoModePtr: Pointer;
  end;
var
  VesaInfo: array[0..255] of Byte;
const  VESA16Modes: array[0..2] of Word =
    ($0102, $0104, $0106);
asm
        MOV     AX,SS
        MOV     ES,AX
        LEA     DI,VesaInfo
        MOV     AX,4F00H
        INT     10H
        CMP     AX,004FH
        MOV     AX,grError
        JNZ     @@Exit
        CMP     ES:[DI].VgaInfoBlock.VESASignature.Word[0], 'EV'
        JNZ     @@Exit
        CMP     ES:[DI].VgaInfoBlock.VESASignature.Word[2], 'AS'
        JNZ     @@Exit
        LES     DI,ES:[DI].VgaInfoBlock.VideoModePtr
        PUSH    ES
        PUSH    DI
        MOV     AX, OFFSET Vesa16Modes
        PUSH    AX
        MOV     AX,3
        PUSH    AX
        CALL    GetHighestCap
@@Exit:
end;
begin
 vesa16:=InstallUserDriver('VESA16', @DetectVESA16);
 registerbgidriver(@vesa16driverProc);
 vesa:=grapherrormsg(graphresult);
end;

function ibm:string;
begin
 registerbgidriver(@ibm8514driverProc);
 ibm:=grapherrormsg(graphresult);
end;
function goth:string;
begin
 registerbgifont(@gothicfontProc);
 goth:=grapherrormsg(graphresult);
end;
function sans:string;
begin
 registerbgifont(@sansseriffontProc);
 sans:=grapherrormsg(graphresult);
end;
function small:string;
begin
 registerbgifont(@smallfontProc);
 small:=grapherrormsg(graphresult);
end;
function trip:string;
begin
 registerbgifont(@triplexfontProc);
 trip:=grapherrormsg(graphresult);
end;
function bold:string;
begin
 registerbgifont(@boldfontProc);
 bold:=grapherrormsg(graphresult);
end;
function euro:string;
begin
 registerbgifont(@eurofontProc);
 euro:=grapherrormsg(graphresult);
end;
function lcom:string;
begin
 registerbgifont(@lcomfontProc);
 lcom:=grapherrormsg(graphresult);
end;
function scri:string;
begin
 registerbgifont(@scrifontProc);
 scri:=grapherrormsg(graphresult);
end;
function simp:string;
begin
 registerbgifont(@simpfontProc);
 simp:=grapherrormsg(graphresult);
end;
function tscr:string;
begin
 registerbgifont(@tscrfontProc);
 tscr:=grapherrormsg(graphresult);
end;
end.