{$G+}
unit mycrt;

interface

const      bildseite :byte   =0;

procedure endint9;
function  getscan:byte;
procedure initint9;
procedure putstr(x,y,farbe:byte;s:string);
procedure putchar(x,y,farbe:integer;n:char);
procedure smoothscroll(x,y,x_dir,y_dir:integer;var end_x,end_y:integer);
function transfarbe(vf,hf:integer):integer;
procedure setxyfarbe(x,y,vf,hf:integer);
procedure kasten(hoehe,breite,anf,vfarb,hfarb:shortint;Schatten:boolean;Titel:string);
function getfarbe(x,y:integer):integer;
function getchar(x,y:integer):integer;
procedure setto(x,y:byte);
procedure settextpage(i:byte);
function GetCursor : Integer;
procedure SetCursor(NewCursor : Integer);
procedure Hidecursor(var oldcursor:integer);
procedure scrollup(anzahl,x1,y1,x2,y2,leer:byte);
procedure scrolldn(anzahl,x1,y1,x2,y2,leer:byte);
function int2str(int:integer):string;
function bool2str(bool:boolean):string;
function bool2strt(bool:boolean):string;
function zahl2str(int:real):string;
function int2strl(int,l:integer):string;
function wor2strl(w:word;l:integer):string;

implementation
uses crt,dos,modexlib;

const INT_CTR   = $20;                   {;Port des Interrupt-Controllers}
      EOI       = $20;                   {;End-of-Interrupt-Kommando}
      KB_PORT   = $60;                   {;Tastatur-Port}
      scanend   =  31;

type  longptr  = ^longint;

const int9_ofs :word=0;                    {;Offsetadresse des alten Handlers}
      int9_seg :word=0;                    {;Segmentadresse des alten Handlers}
      int9_ptr :longptr=@int9_ofs;       {;alter Interrupt-Vektor 9h}

var   scanbuf  :array [0..scanend] of byte;   {;Puffer fr Scan-Codes}

      scannext :word; { dw offset scanbuf       {;nchstes Zeichen im Scan-Puffer}
      scanlast :word; { dw offset scanbuf       {;letztes Zeichen im Scan-Puffer}

procedure neui9; far; assembler;
asm
          push ax                 {;AX auf dem Stack sichern}
          in   al,KB_PORT         {;Scan-Code vom Tastatur-Port holen}

          cmp  al,128             {;Release-Code?}
          jnb   @i9ende           {;Nein ---> merken}

  {;-- Scan-Code im Scan-Puffer ablegen -------------------------}

          push di                 {;Di wird gebraucht, daher sichern}
          mov  di, offset scanbuf       {;DI auf nchste Puffer-Position}
          add  di, scanlast
          mov  cs:[di],al         {;Scan-Code dort ablegen}
          inc  di                 {;DI auf nchste Position}
          cmp  scanlast+1, scanend+1  {;berlauf?}
          jne  @i9nowrap           {;Nein ---> merken}

          mov  di,offset scanbuf  {;Ja, wieder auf den Anfang}

@i9nowrap: mov  scanlast,di        {;nchste Zeichenposition merken}
          pop  di                 {;DI wieder zurck}

@i9ende:  pop  ax                 {;Scancode an alten Tastatur-Handler}
          jmp  [int9_ptr]         {;bergeben}
end;

procedure initint9;assembler;
asm
          mov  ax,3509h           {;Inhalt des Interruptvektors 9h holen}
          int  21h                {;DOS-Funktion aufrufen}
          mov  int9_seg,es        {;Segment- und Offsetadresse des}
          mov  int9_ofs,bx        {;Interruptvektors 9h merken}

          mov  dx,offset neui9    {;Offsetadresse neue Interrupt-Routine}
          mov  ax,2509h           {;Interruptvektor 9h auf}
          int  21h                {;eigene Routine verbiegen}
          mov  scannext,0
          mov  scanlast,0
end;


function getscan:byte;
begin
 if scanlast <> scannext then
  begin
   getscan:=scanbuf[scannext];
   inc(scannext);
   if scannext>scanend then scannext:=0;
  end;
end;


procedure endint9;assembler;
asm
          lds  dx,int9_ptr        {;wieder den alten Tastatur-Interrupt-}
          mov  ax,2509h           {;Handler installieren}
          int  21h
end;


function bool2str(bool:boolean):string;
begin
 if bool then bool2str:='Ja' else bool2str:='Nein'
end;

function bool2strt(bool:boolean):string;
begin
 if bool then bool2strt:='TRUE' else bool2strt:='FALSE'
end;

function zahl2str(int:real):string;
var s:string;
begin
 str(int,s);
 zahl2str:=s;
end;

function int2str(int:integer):string;
var s:string;
begin
 str(int,s);
 int2str:=s;
end;

function int2strl(int,l:integer):string;
var s:string;
begin
 str(int,s);
 while length(s)<l do s:='0'+s;
 int2strl:=s;
end;

function wor2strl(w:word;l:integer):string;
var s:string;
begin
 str(w,s);
 while length(s)<l do s:='0'+s;
 wor2strl:=s;
end;

procedure scrollup(anzahl,x1,y1,x2,y2,leer:byte);assembler;
asm
 mov ah, 06h
 mov al, anzahl
 mov ch, y1
 mov cl, x1
 mov dh, y2
 mov dl, x2
 mov bh, leer
 int 10h
end;

procedure scrolldn(anzahl,x1,y1,x2,y2,leer:byte);assembler;
asm
 mov ah, 07h
 mov al, anzahl
 mov ch, y1
 mov cl, x1
 mov dh, y2
 mov dl, x2
 mov bh, leer
 int 10h
end;

function GetCursor : Integer;
var
  Reg : Registers;
begin
  with Reg do
  begin
    AH := 3;
    BH := 0;
    Intr($10, Reg);
    GetCursor := CX;
  end;
end;

procedure SetCursor(NewCursor : Integer);
var Reg : Registers;
begin
  with Reg do
  begin
    AH := 1;
    BH := 0;
    CX := NewCursor;
    Intr($10, Reg);
  end;
end;

procedure Hidecursor(var oldcursor:integer);
begin
  oldCursor := GetCursor;
  SetCursor($2000);
end;

procedure setto(x,y:byte);assembler;
asm
 mov ah,02h
 mov bh,bildseite
 mov dh,y
 mov dl,x
 int 10h
end;

procedure settextpage(i:byte);assembler;
asm
 mov ah, 05h
 mov al, i
 int 10h
end;

function getchar(x,y:integer):integer;
begin
 getchar:=mem[$B800:(y-1)*160+(x-1)*2];
end;

function getfarbe(x,y:integer):integer;
begin
 getfarbe:=mem[$B800:(y-1)*160+(x-1)*2+1];
end;

function transfarbe(vf,hf:integer):integer;
begin
 transfarbe:=16*hf+vf
end;

procedure setxyfarbe(x,y,vf,hf:integer);
begin
 mem[$B800:(y-1)*160+(x)*2+1]:=transfarbe(vf,hf);
end;

procedure putchar(x,y,farbe:integer;n:char);
begin
asm
       mov    cx,[bp+0Ch] {x}
       dec    cx
       shl    cx,1
       mov    ax,[bp+0Ah]  {y}
       dec    ax
       mov    dx,00A0h
       mul    dx
       add    ax,cx
       mov    di,ax
       push   0B800h
       pop    es
       mov    al,[bp+06h]  {n}
       mov    ah,[bp+08] {farbe}
       stosw

end;
end;

procedure putstr(x,y,farbe:byte;s:string);
begin
 asm
{************ Sicherheit : ist String <> ''? *******************************}
              mov    cx,0001h           {bereite cmp vor}
              cmp    cl,[bp-0100h]      {lnge mit ch vergleichen}
              ja     @ende              {if ch grer,bzw. lnge<1}
{************ Start-Offset errechnen ***************************************}
              mov    bl,0A0h            {160 nach bl}
              mov    dx,[bp+0Eh]        {tue x in dx}
              dec    dx                 {x-1 weil im Speicher oben links=0}
              shl    dx,1               {dx mal 2}
              mov    ax,[bp+0Ch]        {y nach ax}
              dec    ax                 {y-1 weil im Speicher oben links=0}
              mul    bl                 {ax mal 160 (bl)}
              add    ax,dx              {nun ax:=ax+dx (x*2)}
{************ Vorbereitung der Register ************************************}
              mov    bh,[bp+0Ah]        {die farbe nach bh}
              push   0B800h             {Segment auf den Stack}
              pop    es                 {von dort nach es}
              jmp    @erste_mal         {berspringe erhhen}
{************ Schleife frs ausgeben der einzelnen Zeichen *****************}
@schleife:    inc    cl                 {inc(i)}
@erste_mal:   mov    di,cx              {cx auf di um auf neuen char zu zeigen}
              mov    bl,[bp+di-0100h]   {nun schiebe akt. char nach bl}
              mov    di,ax              {zum schluss ax als offset nach di}
              mov    es:[di],bx         {jetzt char+farbe in den Speicher}
              add    ax,02h             {erhhe offset um 2}
              cmp    cl,[bp-0100h]      {ist i=lnge?}
              jne    @schleife          {wenn nicht equal dann spring}
@ende:
end;
end;

procedure kasten(hoehe,breite,anf,vfarb,hfarb:shortint;Schatten:boolean;Titel:string);
 var i,a,i2:integer;
 Begin
  a := (82-(breite+2)) div 2;
  putchar (a,anf,vfarb+15+hfarb,'');
  for i := 1 to breite do putchar (a+i,anf,vfarb+15+hfarb,'');
  putchar (a+i+1,anf,vfarb+15+hfarb,'');
  for i := 1 to hoehe do
   begin
     putchar (a,anf+i,vfarb+15+hfarb,'');
     for i2 := 1 to breite do putchar (a+i2,anf+i,15+hfarb,' ');
     putchar (a+breite+1,anf+i,vfarb+15+hfarb,'');
     if schatten then putchar (a+breite+2,anf+i,0,'');
   end;
 putchar (a,anf+hoehe+1,vfarb+15+hfarb,'');
 for i := 1 to breite do putchar (a+i,anf+hoehe+1,vfarb+15+hfarb,'');
 putchar (a+i+1,anf+hoehe+1,vfarb+15+hfarb,'');
 if schatten then
  begin
   putchar (a+i+2,anf+hoehe+1,0,' ');
   for i:=1 to breite+2 do putchar (a+i,anf+hoehe+2,14*8,'');
  end;
 if (titel<>'') then putstr(38-(length(titel) div 2),anf,transfarbe(vfarb,hfarb),' '+titel+' ');
 textcolor(vfarb);
 textbackground(hfarb);
 gotoxy(1,1);
end;

Procedure Wait_In_Display;assembler;
{Gegenstck zu Wait_In_Retrace, wartet auf Bildaufbau durch Kathodenstrahl}
asm
  mov dx,3dah                   {Input Status 1}
@wait2:
  in al,dx
  test al,8h
  jnz @wait2                    {Display ein ? -> dann fertig}
End;

Procedure Wait_In_Retrace;assembler;
{wartet auf Retrace, setzt auerdem durch Lesezugriff
 auf Input Status 1 den ATC Flip-Flop zurck}
asm
  mov dx,3dah                   {Input Status 1}
@wait1:
  in al,dx
  test al,8h
  jz @wait1                     {Retrace aktiv ? -> dann fertig}
End;

Procedure V_Pan(n:Byte);assembler;
{fhrt vertikales Paning durch}
asm
  mov dx,3d4h                   {CRTC Register 8 (Inittial Row Adress)}
  mov al,8
  mov ah,n                      {Paning-Weite setzen}
  out dx,ax
End;

Procedure H_Pan(n:Byte);assembler;
{fhrt vertikales Paning durch}
asm
  mov dx,3c0h                   {ATC Index/Data Port}
  mov al,13h or 32d             {Register 13h (Horizontal Pixel Paning)}
  out dx,al                     {anwhlen; Bit 5 (Palette RAM Address Source)}
  mov al,n                      {setzen, um Bildschirm nicht abzuschalten}
  or al,32d                     {Paning-Wert schreiben}
  out dx,al
End;

procedure smoothscroll(x,y,x_dir,y_dir:integer;var end_x,end_y:integer);
var tendx,tendy:integer;
begin
 tendx:=end_x;
 tendy:=end_y;                        {Koordinaten und Richtungen initialisieren}
  Repeat
    dec(x,x_dir);               {Bewegung in x- und y-Richtung}
    Inc(y,y_dir);
    end_x:=x;
    end_y:=y;
    If (x<=-80*9) or (x>=80*9)      {Umkehr an den Rndern}
      Then x_dir:=-x_dir;
    if (y<=0) or (y>=25*16)
      Then y_dir:=-y_dir;
    Wait_in_Display;            {warten, bis Bildaufbau luft}
    SetStart((y div 16 *160)    {Startadresse setzen (Grobscrolling}
      + x div 9);
    Wait_in_Retrace;            {warten, bis Retrace aktiv}
    V_Pan(y mod 16);            {Vertikal-Panning   (Feinscrolling)}
    H_Pan((x-1) mod 9);         {Horizontal-Panning (Feinscrolling)}
  Until (x=tendx) or (y=tendy) or keypressed            {warten auf Taste}
end;

end.