/******************************************************************************
 *  bwm-ng v0.1                                                               *
 *                                                                            *
 *  Copyright (C) 2004 Volker Gropp (vgropp@pefra.de)                         *
 *                                                                            *
 *  for more info read README.                                                *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <curses.h>
#include <getopt.h>
#include <limits.h>
#include <signal.h>

#define MAJOR 0
#define MINOR 1

struct iface_stats {
    char    *if_name;
    unsigned long long rec;
    unsigned long long send;
};

typedef struct iface_stats t_iface_stats;
int if_count=0;
char PROC_NET_DEV[PATH_MAX];
unsigned int delay=500;

/* global buffer to store all data of interfaces in */
t_iface_stats *if_stats=NULL;
/* total struct */
t_iface_stats if_stats_total;

/* clear stuff */
int deinit() {
	/* first close curses, so we dont leave mess behind */
	endwin();
	curs_set(1);
	/* we should clean if_state, i think, */
	if (if_stats!=NULL) free(if_stats);
	/* we are done, say goodbye */
    exit(0);
}


/* sigint handler */
void sigint(int sig) {
	/* we got a sigint, call deinit and exit */
	deinit();
}

/* allocate and init the global struct we use to store the data */
int init_if_stats() {
    FILE *f;
    int i,k;
    char buffer[4096],bytesr[4096],bytess[4096];
	char buf[4096]; /* dummy buffer, anyone knows a better solution? */
    if_stats_total.rec=0; /* init total */
    if_stats_total.send=0;
	
    if ((f=fopen(PROC_NET_DEV,"r"))) {
        /* skip first 2 lines */
        if ((fgets(buffer,4095,f) != NULL ) && (fgets(buffer,4095,f) != NULL )) {
            while (fgets(buffer,4095,f) != NULL ) {
				/* ok we should found another interface, lets init it */
                if_count++;
				/* alloc some mem for it */
                if_stats=(t_iface_stats*)realloc(if_stats,sizeof(t_iface_stats)*if_count);
				/* get the name */
                i=0;
                while (buffer[i]<=32 && buffer[i]!=0) i++;
                k=i+1;
                while (buffer[k]!=':' && buffer[k]!=0) k++;
                if (buffer[k]!=0) {
                    buffer[k]=0;
                    if_stats[if_count-1].if_name=(char*)strdup((char*)&buffer[i]);
                } else if_stats[if_count-1].if_name=(char*)strdup("unknown");
				/* get first values */
				k++;
				sscanf(&buffer[k],"%s %s %s %s %s %s %s %s %s",bytesr,buf,buf,buf,buf,buf,buf,buf,bytess);
				if_stats[if_count-1].rec=atof(bytesr);
				if_stats[if_count-1].send=atof(bytess);
				/* add to total */
                if_stats_total.send+=atof(bytess);
                if_stats_total.rec+=atof(bytesr);

            }
        } /* if skip first 2 lines */
        fclose(f);
		/* ok, we are done, lets get out */
    } else return 0; /* we couldnt open the proc/net, better report it back */
    return 1; /* all fine */
}


/* do the actual work, get and print stats */
void get_iface_stats () {
    FILE *f;
    char buffer[4096],bytesr[4096],bytess[4096];
	char buf[4096]; /* dummy buffer, anyone knows a better solution? */
    int i,k,local_if_count;
	float multiplier=(float)1000/delay;
    t_iface_stats stats; /* local struct, used to calc total values */
    stats.rec=0; /* init it */
    stats.send=0;
    local_if_count=0;
    if ((f=fopen(PROC_NET_DEV,"r"))) {
        while (fgets(buffer,4095,f) != NULL && local_if_count<if_count ) { /* skip header */
            i=0;
			/* get the name of the current iface */
            while (buffer[i]<=32 && buffer[i]!=0) i++;
            k=i+1;
            while (buffer[k]!=':' && buffer[k]!=0) k++;
            if (buffer[k]!=0) { /* is there any data left? */
                buffer[k]=0;
                mvwprintw(stdscr,3+local_if_count,8,"%12s:",&buffer[i]); /* output the name */
                /* get the real data now */
				k++;
                sscanf(&buffer[k],"%s %s %s %s %s %s %s %s %s",bytesr,buf,buf,buf,buf,buf,buf,buf,bytess);
				/* output it */
                wprintw(stdscr,"%12.2f kb/s  ",(double)((atof(bytess)-if_stats[local_if_count].send)*multiplier)/1024);
                wprintw(stdscr,"%12.2f kb/s  ",(double)((atof(bytesr)-if_stats[local_if_count].rec)*multiplier)/1024);
                /* print total (send+rec) of current iface */
                wprintw(stdscr,"%12.2f kb/s  \n",(double)((atof(bytess)+atof(bytesr)-(if_stats[local_if_count].send+if_stats[local_if_count].rec))*multiplier)/1024);
				/* save current stats for the next run */
                if_stats[local_if_count].send=atof(bytess);
                if_stats[local_if_count].rec=atof(bytesr);
				/* add current iface stats to total */
                stats.send+=atof(bytess);
                stats.rec+=atof(bytesr);
                local_if_count++; /* jump to next iface */
            }
        }
        /* output total ifaces stats */
        mvwprintw(stdscr,3+if_count,8,"%12s:","total");
        wprintw(stdscr,"%12.2f kb/s  ",(double)((stats.send-if_stats_total.send)*multiplier)/1024);
        wprintw(stdscr,"%12.2f kb/s  ",(double)((stats.rec-if_stats_total.rec)*multiplier)/1024);
        /* output total of all ifaces */
        wprintw(stdscr,"%12.2f kb/s   \n",(double)((stats.send+stats.rec-(if_stats_total.send+if_stats_total.rec))*multiplier)/1024);
		/* save the data in total-struct */
		if_stats_total.send=stats.send;
		if_stats_total.rec=stats.rec;
        fclose(f);
    }
    return; 
}

/* prints a helpscreen and exists */
int printhelp() {
	printf("bwm-tng v%i.%i Copyright (C) 2004 Volker Gropp\n",MAJOR,MINOR);
	printf("USAGE: bwm-ng [OPTION] ...\n");
	printf("displays current ethernet interfaces load in kb/s\n\n");
	printf("Options:\n");
	printf("  -t, --timeout <msec>  displays stats every <msec> (1msec = 1/1000sec) default: 500\n");
	printf("  -f, --file <filename> filename to read raw data from. default: /proc/net/dev\n");
	printf("  -h, --help            displays this help\n");
	printf("\n");
	exit(0);
}

int main (int argc, char *argv[]) {
	char c='\0'; /* used for getch */ 
	char o;
	strcpy(PROC_NET_DEV,"/proc/net/dev");
	/* get command line arguments, kinda ugly, wanna rewrite it? */
	while (1) {
		int option_index = 0;
		static struct option long_options[] = {
			{"timeout", 1, 0, 0},
			{"file",1,0,0},
			{"help", 0, 0, 0},
			{0,0,0,0}
		};
		o=getopt_long (argc,argv,"ht:f:",long_options, &option_index);
		if (o==-1) break;
		switch (o) {
			case '?': exit(0);
					  break;
			case 0: if (!strcasecmp(long_options[option_index].name,"help")) printhelp();
						else if (!strcasecmp(long_options[option_index].name,"timeout")) {
							if ((optarg) && atol(optarg)>0) { delay=atol(optarg); }
						} else if (!strcasecmp(long_options[option_index].name,"file")) {
							if (optarg && (strlen(optarg)<PATH_MAX)) strcpy(PROC_NET_DEV,optarg);
						}
					break;
			case 'h':
				printhelp();
				break;
			case 'f':
				if (optarg && (strlen(optarg)<PATH_MAX)) strcpy(PROC_NET_DEV,optarg);
				break;
			case 't':
				if ((optarg) && atol(optarg)>0) { delay=atol(optarg); } 
				break;
		}
	}
	/* init global struct */
	if (!init_if_stats()) {
		printf("unable to init %s\n",PROC_NET_DEV);
		exit(1);
	}
	/* init curses */
	initscr(); 
	cbreak(); 
	noecho();
	nonl();
//	curs_set(0);
	/* end of init curses, now set a sigint handler to deinit the screen on ctrl-break */
	signal(SIGINT,sigint);
	timeout(delay); /* set the timeout of getch to delay in ms) */
    while (1) { /* do the main loop */
        mvwprintw(stdscr,1,8,"bwm-ng v%i.%i (delay %2.3fs), press 'q' to end this",MAJOR,MINOR,(float)delay/1000);
		get_iface_stats(); /* do the actual work, get and print stats */
		refresh();
		c=getch();
		switch (c) {
			/* lets check for known keys */
			case '+': /* increase delay */
				delay+=100;
				timeout(delay);
				break;
			case '-': /* decrease delay */
				if (delay>100) {
					delay+=-100;
					timeout(delay);
				}
				break;
			case 'q':
			case 'Q':
				/* we are asked to exit */
				deinit();
				break;
		}
		c='\0'; /* not really needed, but i like it this way */
    }
	/* we prolly never get here */
	deinit();
}
